*
* The decline of the U.S. Labor Share
* Do file to generate KPSS stationarity test results
* 
* 

* Start with a clean slate
clear all
capture log close
set more off

* Define some variables that track the directory structure and files that the program uses
* ----------------------------------------------------------------------------------------------------------------------------------
* This is the directory where all the files are stored. Change it to the location on your computer
local filespath "C:\Research\FRBSF\Laptop\Brookings2013\Progs\STATA\"
* These are the files the progam accesses.
local logfile  "`filespath'log\Regression results.txt"
local dtafile  "`filespath'data\SectionIV.dta"

* Make sure that STATA writes all your results away to a log file so you can use the file to study your results
* ----------------------------------------------------------------------------------------------------------------------------------
* Make sure there are no line breaks in the log file
set linesize 255
* Log results to a text file that you can cut and paste into whatever application you want
set logtype text
* Restart your log file
log using "`logfile'" , replace

* Load the data
* ----------------------------------------------------------------------------------------------------------------------------------
* Save the data to a STATA format dataset. Replace the file if it already exists
use "`dtafile'", replace

* OLS regressions for comparison with spreadsheet
* ----------------------------------------------------------------------------------------------------------------------------------
gen dshare = share11 - share87
gen dshareprc = 100*dshare/share87
gen dshareKN  = (average_share/(1-average_share))*(ln(share11)-ln(share87))
gen dshareKN2 = (1/(1-average_share))*(share11-share87)
gen dreleqprice = 100*((1+deqprice/100)/(1+dprice/100)-1)
gen dummanuf = 0
replace dummanuf = 1 if (number > 11 )&(number < 34)
gen deqpricemanuf = dummanuf*deqprice
gen dimportexposureunions87 = dimportexposure*unions87

* exclude oil and gas extraction
drop if number == 7
* drop if number == 31

* Karabarbounis-Neiman type regression
* ----------------------------------------------------------------------------------------------------------------------------------
regress dshareKN dreleqprice
regress dshareKN deqprice

* Regression tables for paper
* ----------------------------------------------------------------------------------------------------------------------------------

* OLS regressions
* ----------------------------------------------------------------------------------------------------------------------------------
quietly regress dshare deqprice
estimates store m1, title(OLS-I)
quietly regress dshare dimportexposure
estimates store m2, title(OLS-II)
quietly regress dshare dunions
estimates store m3, title(OLS-III)
quietly regress dshare dsteps
estimates store m4, title(OLS-IV)
quietly regress dshare deqprice
estimates store m5, title(OLS-V)
quietly regress dshare deqprice dimportexposure
estimates store m6, title(OLS-VI)
quietly regress dshare deqprice dimportexposure dunions 
estimates store m7, title(OLS-VII)
quietly regress dshare deqprice dimportexposure dunions unions87 dimportexposureunions87
estimates store m8, title(OLS-VIII)

estout m1 m2 m3 m4, cells(b(star fmt(3)) se(par fmt(2))) ///
   legend label varlabels(_cons Constant) ///
   stats(r2 df_r)
estout m5 m6 m7, cells(b(star fmt(3)) se(par fmt(2))) ///
   legend label varlabels(_cons Constant) ///
   stats(r2 df_r)
   
* WLS regressions
* ----------------------------------------------------------------------------------------------------------------------------------
quietly regress dshare deqprice [aw=vashare]
estimates store m1, title(WLS-I)
quietly regress dshare dimportexposure [aw=vashare]
estimates store m2, title(WLS-II)
quietly regress dshare dunions [aw=vashare]
estimates store m3, title(WLS-III)
quietly regress dshare dsteps [aw=vashare]
estimates store m4, title(WLS-IV)
quietly regress dshare deqprice [aw=vashare]
estimates store m5, title(WLS-V)
quietly regress dshare deqprice dimportexposure [aw=vashare]
estimates store m6, title(WLS-VI)
quietly regress dshare deqprice dimportexposure dunions [aw=vashare]
estimates store m7, title(WLS-VII)
quietly regress dshare deqprice dimportexposure dunions unions87 dimportexposureunions87 [aw=vashare]
estimates store m8, title(WLS-VIII)

estout m1 m2 m3 m4, cells(b(star fmt(3)) se(par fmt(2))) ///
   legend label varlabels(_cons Constant) ///
   stats(r2 df_r)
estout m5 m6 m7, cells(b(star fmt(3)) se(par fmt(2))) ///
   legend label varlabels(_cons Constant) ///
   stats(r2 df_r)
   
* Close the log file
* ----------------------------------------------------------------------------------------------------------------------------------
log close
